//********************************************************************************
//Project Name : Sensorless Source Code
//Date : 2023.2.14
//MCU : MDRFD0
//Others : Sensorless ; 1Pole Pairs

//Ru-v = R 	 / Rv-w = R   / Ru-w = R
//Lu-v = uH / Lv-w = uH / Lu-w = uH
//********************************************************************************
//								      MEMO
//********************************************************************************
//v1.0: GUI version.

//********************************************************************************
//								     Include
//********************************************************************************
#include "MDRFxx_SFR.h"
#include "Allhex.h"

//********************************************************************************
//								       RAM
//********************************************************************************
//The variables defined by data are placed in the first 128 bytes (0x00~0x7F) address space
//The variables defined by idata are placed in the (0x00~0xFF) address space
//The variable defined by xdata are placed in the external extended RAM  (generally refers to the external 0xF000~0xF1FF space, the specific space size varies with the MCU , and some MCU do not have external RAM)

//The variable defined by data is the fastest, followed by idata, and xdata is slower than the first two
//Variables that are often used are declared with data/idata; variables that are not commonly used are declared with xdata.
//No special declared variables, the default is data//xdata MCU_COMPONENT Mcu_Component;
//xdata PMCU_COMPONENT pMcu_Component =& Mcu_Component;

//MCU_COMPONENT Mcu_Component;
//PMCU_COMPONENT pMcu_Component =& Mcu_Component;

bit ZeroFlag;
bit Start_Power_On;

unsigned short IPDCount = 0;
unsigned char IPDFlag = 0;

unsigned char TimerFlag = 0;
unsigned char TimerCount = 0;

unsigned char PwmFlag = 0;
unsigned short PwmCount = 0; 

#define TIMER_Frequency2 1000 // unit : Hz
#define TIMER_Counter2 2000000/TIMER_Frequency2
#define TIMER_TH2 (65535-TIMER_Counter2)>>8
#define TIMER_TL2 (65535-TIMER_Counter2)&0xFF

//xdata unsigned short Speed = 2000; // unit : rpm
//xdata unsigned short FreqCal;
//xdata unsigned short RpmTemp;
//xdata unsigned short RpmTempH;
//xdata unsigned short RpmTempL;

//xdata unsigned short Ang;
//xdata unsigned long Ang_C;

//void FG_Fun (void)
//{
//	int Tmp;
//	SFR_PAGE = 6; Tmp = SMO_D1;
//	Ang = DATA_FILTER(Tmp, Ang_C, Ang, signed short, 2);
//	if((Ang) > (191<<6)) P0_4 = 1;
//	else                 P0_4 = 0;
//}

//********************************************************************************
//								    MAIN
//********************************************************************************
void main (void){
	PWM_SetAllOff();
	GPIO_Init();
	PWM_Init();
	Adc_Init();
	Timer_Init();
	OCP_Init();
	MOC_Init();
	Interrupt_Init();
	
	#if (Uart_Debug == 1)
		Uart_Definition();
	#endif
	
	#if (Uart_Debug == 0)
		led_a_OUTPUT;
		led_b_OUTPUT;
		led_c_OUTPUT;
		led_a = 0;
		led_b = 0;
		led_c = 0;
	#endif
	
	//LVD_Init();
	WatchDog_Init();// (note : IPD will trigger WatchDog Reset)
	CAP_Init();
	
	#if (CONTROL_MODE == Power_Control) //|| (CONTROL_MODE == 2)
		InitPI_ALL();
		InitPI(&PIParm_Watt);
	#endif
	
	#if 1
	i2c_Init();
	Heat_Level = i2c_Cnt;
	#endif
	while (1){
		WatchDog_Refresh();
		if(ZeroFlag){			
			Heat_Control();
			ZeroFlag = 0;
		}
		//IPDFlag = 1;
//		if(IPDFlag == 1)
//		{
//			if(IPDCount >= PeriodTime1000ms)
//			{
//				Break_Fun();
//				//WatchDog_Disable();// ( note : IPD will trigger WatchDog Reset, Disable WatchDog)
//				IPD_Init();
//				//WatchDog_Init();
//				IPDCount = 0;
//			}
//		}
		
		if(PwmFlag == 1){
			SW_HOT_COOL_LED();
			//FG_Fun();
			#if (BEMF_TWO_TAILWIND_FUNCTION_RES == 1) || (BEMF_TWO_TAILWIND_FUNCTION_DIODE == 1) || (BEMF_ONE_TAILWIND_FUNCTION == 1)
			if(MotorState == M_TAILWIND){
				#if (BEMF_TWO_TAILWIND_FUNCTION_RES == 1)
				TailWindDetect_TwoBEMF_Fun();
				#endif
				#if (BEMF_TWO_TAILWIND_FUNCTION_DIODE == 1)
					#if (BREAK_FUNCTION == 1)
						if(!ZeroPointCheck)
							Break_Fun();
						else
							PWM_SetActive();
						TailWindDetect_TwoBEMF_Fun();
					#else
						#error Wrong Setting BREAK_FUNCTION Disable !!
					#endif
				#endif
				#if (BEMF_ONE_TAILWIND_FUNCTION == 1)
				TailWindDetect_OneBEMF_Fun();
				#endif
			}
			#endif
			PwmFlag = 0;
		}
		#if (Uart_Debug == 1)
		if(RxState == RX_FINISH){
			Uart_ReadPackage_Build();
		}
		
		if(UartFlag == 1){
			Uart_Package_Build();
			UartFlag = 0;
		}
		#endif
		
		if(TimerFlag == 1){
			TimerFlag = 0;
			Speed_Level_Fun();
			#if (Uart_Debug == 0)
			Led_Control(ZERO_Check,Error_Status);//Start_Power_On ZERO_Check
			#endif
			if((TimerCount & 0x0F) == 0)// 0.16.32...etc 16ms
			{
				Heat_Level_Fun();
			#if 0
				FreqCal = EstimatedSpeed;
				if(FreqCal > 2000)
				{
					RpmTemp = 120000000/FreqCal;
					RpmTempH = (65535-RpmTemp)>>8;
					RpmTempL = (65535-RpmTemp)&0xFF;
				}
			#endif
			}
			else if((TimerCount & 0x1F) == 2)//2.34...etc 2 *16ms
			{
				Key_Scan(Speed_Level);
#if 1
				if(i2c_Save){
					i2c_Busy = 1; // SCL share pin and need to avoid NTC ADC starting 
					PINCONG1 &= 0xCF;
					PINCONG1 |= 0x10;// SCL Set Output
					i2c_writebyte(0x01,i2c_Cnt);
					PINCONG1 &= 0xCF;
					PINCONG1 |= 0x20;// SCL Set Input
					i2c_Busy = 0; // SCL share ping and need to avoid NTC_ADC clear
					i2c_Save = 0;// i2c_Save = 0 End save eeprom
				}
#endif
				//GET_IQ_MACRO(IqFb);
			}
			else if((TimerCount & 0x1F) == 4)//4.36...etc 2 *16ms
			{
				#if ((CONTROL_MODE == Power_Control) || (CONTROL_MODE == Power_Limit))
				PowerCla_Fun();
				#endif
				//Pi_Ctrl(Heat_Temperture_avg,400);//Heat_Temperture_avg
				//GET_VQ_MACRO(IqPiOut);
			}
			else if((TimerCount & 0x1F) == 6)//6.38...etc 2 *16ms
			{
				GET_SPEED_MACRO(EstimatedSpeed);
			}
			else if((TimerCount & 0x1F) == 8)//8.16.24.32...etc
			{
				Error_Priority();
			}
		}
	}
}